package parser;

/**
 * Grammar non-terminal -- E1a ::= + E
 */
public class E1a implements E1 {
    /**
     * Plus object.
     */
    private PlusToken _plus;

    /**
     * E object.
     */
    private E _e;

    /**
     * Constructor for the E1a grammar non-terminal.
     *
     * @param plus plus object
     * @param e    E object
     */
    public E1a(PlusToken plus, E e) {
        _plus = plus;
        _e = e;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _plus.toString() + _e.toString();
    }
}

